/*
 * Copyright 2003-2006 The Apache Software Foundation.

 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * This file was auto-generated by the Axis C++ Web Service Generator (WSDL2Ws)
 * This file contains functions to manipulate type Alias
 */

#include <stdlib.h>
#include <string.h>

#include "Alias.h"

#include <axis/client/Stub.h>
#include <axis/client/Call.h>
#include <axis/AxisWrapperAPI.h>
#include <axis/IWrapperSoapSerializer.h>
#include <axis/IWrapperSoapDeSerializer.h>


/**
 ******************************************************************************
 * Function to serialize an object of type Alias.
 ******************************************************************************
 */

int Axis_Serialize_Alias(Alias* param, AXISCHANDLE pSZ, AxiscBool bArray)
{
	AxiscBool blnIsNewPrefix = xsdc_boolean_false;
	AxiscBool blnIsNewSubElemPrefix = xsdc_boolean_false;
	const AxiscChar* sPrefix;


	// ======================================================================
	// If null input, serialize as nil element.
	// ======================================================================

	if ( param == NULL )
	{
		axiscSoapSerializerSerializeAsAttribute(pSZ, "xsi:nil", 0, (void*)&(xsdc_boolean_true), XSDC_BOOLEAN);
		axiscSoapSerializerSerialize(pSZ, ">", NULL);
		return AXISC_SUCCESS;
	}

	// ======================================================================
	// Serialize top-most element, possibly defining new namespace.
	// ======================================================================

	if (!bArray)
	{
		sPrefix = axiscSoapSerializerGetNamespacePrefix(pSZ,Axis_URI_Alias, &blnIsNewPrefix);
		if (blnIsNewPrefix)
			axiscSoapSerializerSerialize(pSZ," xmlns:", sPrefix, "=\"", Axis_URI_Alias, "\"", NULL);
	}
	axiscSoapSerializerSerialize(pSZ, ">", 0);

	// ======================================================================
	// Serialize sub-elements.
	// ======================================================================

	if (param->country != NULL)
		axiscSoapSerializerSerializeAsElement(pSZ, "country", "http://service.attributes.sample.webservice.wsdl2rpg.tools400.de/xsd", (void*)(param->country), XSDC_STRING);
	if (param->language != NULL)
		axiscSoapSerializerSerializeAsElement(pSZ, "language", "http://service.attributes.sample.webservice.wsdl2rpg.tools400.de/xsd", (void*)(param->language), XSDC_STRING);
	if (param->name != NULL)
		axiscSoapSerializerSerializeAsElement(pSZ, "name", "http://service.attributes.sample.webservice.wsdl2rpg.tools400.de/xsd", (void*)(param->name), XSDC_STRING);

	// ======================================================================
	// Remove namespace, if new.
	// ======================================================================

	if (!bArray && blnIsNewPrefix)
		axiscSoapSerializerRemoveNamespacePrefix(pSZ, Axis_URI_Alias);

	return AXISC_SUCCESS;
}

/**
 ******************************************************************************
 * Function to deserialize an object of type Alias.
 ******************************************************************************
 */

int Axis_DeSerialize_Alias(Alias* param, AXISCHANDLE pDZ)
{
	const char* peekedElementName;

	// ======================================================================
	// Deserialize elements.
	// ======================================================================

	param->country = axiscSoapDeSerializerGetElementAsString(pDZ, "country",0);

	param->language = axiscSoapDeSerializerGetElementAsString(pDZ, "language",0);

	param->name = axiscSoapDeSerializerGetElementAsString(pDZ, "name",0);



	// ======================================================================
	// Ensure no extraneous elements.
	// ======================================================================

	peekedElementName = axiscSoapDeSerializerPeekNextElementName(pDZ);
	if (0x00 != *peekedElementName)
		axiscAxisGenerateUnknownElementException(peekedElementName);

	return axiscSoapDeSerializerGetStatus(pDZ);
}

/**
 ******************************************************************************
 * Function used to create objects of type Alias.
 ******************************************************************************
 */

void* Axis_Create_Alias(int nSize)
{
	if (nSize > 0)
	{
		int i;
		Alias** pNew = (Alias**) axiscAxisNewCArray(nSize);
		for (i=0; i < nSize; ++i)
			pNew[i] = (Alias*)Axis_Create_Alias(0);
		return (void *)pNew;
	}
	else
	{
		Alias* pTemp = (Alias *)malloc(sizeof(Alias));
		memset(pTemp, 0, sizeof(Alias));

		return pTemp;
	}
}

/**
 ******************************************************************************
 * Function used to delete objects of type Alias.
 ******************************************************************************
 */

void Axis_Delete_Alias(Alias* param, int nSize)
{
	/* If NULL, just return */
	if (param == NULL)
		return;

	/* Reclaim memory resources (recursion is used to reclaim arrays) */
	if (nSize > 0)
	{
		int i;
		Alias **paramArray = (Alias **)param;
		for (i = 0 ; i < nSize ; i++ )
			if (paramArray[i])
				Axis_Delete_Alias(paramArray[i],0);
		axiscAxisDeleteCArray((void **)param);
	}
	else
	{
		if (param->country != NULL)
			axiscAxisDelete(param->country,XSDC_STRING);

		if (param->language != NULL)
			axiscAxisDelete(param->language,XSDC_STRING);

		if (param->name != NULL)
			axiscAxisDelete(param->name,XSDC_STRING);

		free(param);
	}
}
