/*
 * Copyright 2003-2006 The Apache Software Foundation.

 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * This file was auto-generated by the Axis C++ Web Service Generator (WSDL2Ws)
 * This file contains functions to manipulate type Email
 */

#include <stdlib.h>
#include <string.h>

#include "Email.h"

#include <axis/client/Stub.h>
#include <axis/client/Call.h>
#include <axis/AxisWrapperAPI.h>
#include <axis/IWrapperSoapSerializer.h>
#include <axis/IWrapperSoapDeSerializer.h>


/**
 ******************************************************************************
 * Function to serialize an object of type Email.
 ******************************************************************************
 */

int Axis_Serialize_Email(Email* param, AXISCHANDLE pSZ, AxiscBool bArray)
{
	AxiscBool blnIsNewPrefix = xsdc_boolean_false;
	AxiscBool blnIsNewSubElemPrefix = xsdc_boolean_false;
	const AxiscChar* sPrefix;


	// ======================================================================
	// If null input, serialize as nil element.
	// ======================================================================

	if ( param == NULL )
	{
		axiscSoapSerializerSerializeAsAttribute(pSZ, "xsi:nil", 0, (void*)&(xsdc_boolean_true), XSDC_BOOLEAN);
		axiscSoapSerializerSerialize(pSZ, ">", NULL);
		return AXISC_SUCCESS;
	}

	// ======================================================================
	// Serialize top-most element, possibly defining new namespace.
	// ======================================================================

	if (!bArray)
	{
		sPrefix = axiscSoapSerializerGetNamespacePrefix(pSZ,Axis_URI_Email, &blnIsNewPrefix);
		if (blnIsNewPrefix)
			axiscSoapSerializerSerialize(pSZ," xmlns:", sPrefix, "=\"", Axis_URI_Email, "\"", NULL);
	}

	// ======================================================================
	// Serialize attributes.
	// ======================================================================

	if (0 != param->type)
		axiscSoapSerializerSerializeAsAttribute(pSZ,"type", 0, (void*)(param->type), XSDC_STRING);
	if (0 != param->disabled)
		axiscSoapSerializerSerializeAsAttribute(pSZ,"disabled", 0, (void*)(param->disabled), XSDC_BOOLEAN);
	if (0 != param->format)
		axiscSoapSerializerSerializeAsAttribute(pSZ,"format", 0, (void*)(param->format), XSDC_STRING);
	axiscSoapSerializerSerializeAsAttribute(pSZ,"public", 0, (void*)&(param->_public), XSDC_INT);
	if (0 != param->comment)
		axiscSoapSerializerSerializeAsAttribute(pSZ,"comment", 0, (void*)(param->comment), XSDC_ANYTYPE);
	axiscSoapSerializerSerialize(pSZ, ">", 0);

	// ======================================================================
	// Serialize extension.
	// ======================================================================

	axiscSoapSerializerSerializeAsChardata(pSZ,(void*)(param->Email_value), XSDC_STRING);

	// ======================================================================
	// Remove namespace, if new.
	// ======================================================================

	if (!bArray && blnIsNewPrefix)
		axiscSoapSerializerRemoveNamespacePrefix(pSZ, Axis_URI_Email);

	return AXISC_SUCCESS;
}

/**
 ******************************************************************************
 * Function to deserialize an object of type Email.
 ******************************************************************************
 */

int Axis_DeSerialize_Email(Email* param, AXISCHANDLE pDZ)
{
	const char* peekedElementName;

	// ======================================================================
	// Deserialize attributes.
	// ======================================================================

	param->type = axiscSoapDeSerializerGetAttributeAsString(pDZ, "type",0);

	param->disabled = axiscSoapDeSerializerGetAttributeAsBoolean(pDZ, "disabled",0);

	param->format = axiscSoapDeSerializerGetAttributeAsString(pDZ, "format",0);

	{
		xsdc__int * _public = axiscSoapDeSerializerGetAttributeAsInt(pDZ, "public",0);
		if (_public != NULL)
		{
			param->_public = *_public;
			axiscAxisDelete( (void *) _public, XSDC_INT);
		}
	}

	param->comment = axiscSoapDeSerializerGetAttributeAsString(pDZ, "comment",0);


	// ======================================================================
	// Deserialize extension.
	// ======================================================================

	{
		void* pCharDataAs;

		axiscSoapDeSerializerGetChardataAs(pDZ, &pCharDataAs, XSDC_STRING);
		param->Email_value = (xsdc__string) pCharDataAs;
	}


	// ======================================================================
	// Ensure no extraneous elements.
	// ======================================================================

	peekedElementName = axiscSoapDeSerializerPeekNextElementName(pDZ);
	if (0x00 != *peekedElementName)
		axiscAxisGenerateUnknownElementException(peekedElementName);

	return axiscSoapDeSerializerGetStatus(pDZ);
}

/**
 ******************************************************************************
 * Function used to create objects of type Email.
 ******************************************************************************
 */

void* Axis_Create_Email(int nSize)
{
	if (nSize > 0)
	{
		int i;
		Email** pNew = (Email**) axiscAxisNewCArray(nSize);
		for (i=0; i < nSize; ++i)
			pNew[i] = (Email*)Axis_Create_Email(0);
		return (void *)pNew;
	}
	else
	{
		Email* pTemp = (Email *)malloc(sizeof(Email));
		memset(pTemp, 0, sizeof(Email));

		return pTemp;
	}
}

/**
 ******************************************************************************
 * Function used to delete objects of type Email.
 ******************************************************************************
 */

void Axis_Delete_Email(Email* param, int nSize)
{
	/* If NULL, just return */
	if (param == NULL)
		return;

	/* Reclaim memory resources (recursion is used to reclaim arrays) */
	if (nSize > 0)
	{
		int i;
		Email **paramArray = (Email **)param;
		for (i = 0 ; i < nSize ; i++ )
			if (paramArray[i])
				Axis_Delete_Email(paramArray[i],0);
		axiscAxisDeleteCArray((void **)param);
	}
	else
	{
		if (param->type != NULL)
			axiscAxisDelete(param->type,XSDC_STRING);

		if (param->disabled != NULL)
			axiscAxisDelete(param->disabled,XSDC_BOOLEAN);

		if (param->format != NULL)
			axiscAxisDelete(param->format,XSDC_STRING);

		if (param->comment != NULL)
			axiscAxisDelete(param->comment,XSDC_ANYTYPE);

		free(param);
	}
}
