/*
 * Copyright 2003-2006 The Apache Software Foundation.

 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * This file was auto-generated by the Axis C++ Web Service Generator (WSDL2Ws)
 * This file contains functions to manipulate type Nephews
 */

#include <stdlib.h>
#include <string.h>

#include "Nephews.h"

#include <axis/client/Stub.h>
#include <axis/client/Call.h>
#include <axis/AxisWrapperAPI.h>
#include <axis/IWrapperSoapSerializer.h>
#include <axis/IWrapperSoapDeSerializer.h>


/**
 ******************************************************************************
 * Function to serialize an object of type Nephews.
 ******************************************************************************
 */

int Axis_Serialize_Nephews(Nephews* param, AXISCHANDLE pSZ, AxiscBool bArray)
{
	AxiscBool blnIsNewPrefix = xsdc_boolean_false;
	AxiscBool blnIsNewSubElemPrefix = xsdc_boolean_false;
	const AxiscChar* sPrefix;


	// ======================================================================
	// If null input, serialize as nil element.
	// ======================================================================

	if ( param == NULL )
	{
		axiscSoapSerializerSerializeAsAttribute(pSZ, "xsi:nil", 0, (void*)&(xsdc_boolean_true), XSDC_BOOLEAN);
		axiscSoapSerializerSerialize(pSZ, ">", NULL);
		return AXISC_SUCCESS;
	}

	// ======================================================================
	// Serialize top-most element, possibly defining new namespace.
	// ======================================================================

	if (!bArray)
	{
		sPrefix = axiscSoapSerializerGetNamespacePrefix(pSZ,Axis_URI_Nephews, &blnIsNewPrefix);
		if (blnIsNewPrefix)
			axiscSoapSerializerSerialize(pSZ," xmlns:", sPrefix, "=\"", Axis_URI_Nephews, "\"", NULL);
	}
	axiscSoapSerializerSerialize(pSZ, ">", 0);

	// ======================================================================
	// Serialize sub-elements.
	// ======================================================================

	axiscSoapSerializerSerializeCmplxArray(pSZ, (const Axisc_Array *)param->nephews, (void*)Axis_Serialize_Person, (void*)Axis_Delete_Person, "nephews", "http://service.attributes.sample.webservice.wsdl2rpg.tools400.de/xsd");

	// ======================================================================
	// Remove namespace, if new.
	// ======================================================================

	if (!bArray && blnIsNewPrefix)
		axiscSoapSerializerRemoveNamespacePrefix(pSZ, Axis_URI_Nephews);

	return AXISC_SUCCESS;
}

/**
 ******************************************************************************
 * Function to deserialize an object of type Nephews.
 ******************************************************************************
 */

int Axis_DeSerialize_Nephews(Nephews* param, AXISCHANDLE pDZ)
{
	const char* peekedElementName;

	// ======================================================================
	// Deserialize elements.
	// ======================================================================

	axiscSoapDeSerializerGetCmplxArray(pDZ, (Axisc_Array *)param->nephews, (void*)Axis_DeSerialize_Person, (void*)Axis_Create_Person, (void*)Axis_Delete_Person, "nephews", Axis_URI_Person);



	// ======================================================================
	// Ensure no extraneous elements.
	// ======================================================================

	peekedElementName = axiscSoapDeSerializerPeekNextElementName(pDZ);
	if (0x00 != *peekedElementName)
		axiscAxisGenerateUnknownElementException(peekedElementName);

	return axiscSoapDeSerializerGetStatus(pDZ);
}

/**
 ******************************************************************************
 * Function used to create objects of type Nephews.
 ******************************************************************************
 */

void* Axis_Create_Nephews(int nSize)
{
	if (nSize > 0)
	{
		int i;
		Nephews** pNew = (Nephews**) axiscAxisNewCArray(nSize);
		for (i=0; i < nSize; ++i)
			pNew[i] = (Nephews*)Axis_Create_Nephews(0);
		return (void *)pNew;
	}
	else
	{
		Nephews* pTemp = (Nephews *)malloc(sizeof(Nephews));
		memset(pTemp, 0, sizeof(Nephews));

		pTemp->nephews = Axis_Create_Person_Array(0);

		return pTemp;
	}
}

/**
 ******************************************************************************
 * Function used to delete objects of type Nephews.
 ******************************************************************************
 */

void Axis_Delete_Nephews(Nephews* param, int nSize)
{
	/* If NULL, just return */
	if (param == NULL)
		return;

	/* Reclaim memory resources (recursion is used to reclaim arrays) */
	if (nSize > 0)
	{
		int i;
		Nephews **paramArray = (Nephews **)param;
		for (i = 0 ; i < nSize ; i++ )
			if (paramArray[i])
				Axis_Delete_Nephews(paramArray[i],0);
		axiscAxisDeleteCArray((void **)param);
	}
	else
	{
		if (param->nephews)
			Axis_Delete_Person_Array(param->nephews, 0);
		free(param);
	}
}
