/*
 * Copyright 2003-2006 The Apache Software Foundation.

 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * This file was auto-generated by the Axis C++ Web Service Generator (WSDL2Ws)
 * This file contains functions to manipulate type Person
 */

#include <stdlib.h>
#include <string.h>

#include "Person.h"

#include <axis/client/Stub.h>
#include <axis/client/Call.h>
#include <axis/AxisWrapperAPI.h>
#include <axis/IWrapperSoapSerializer.h>
#include <axis/IWrapperSoapDeSerializer.h>


/**
 ******************************************************************************
 * Function to serialize an object of type Person.
 ******************************************************************************
 */

int Axis_Serialize_Person(Person* param, AXISCHANDLE pSZ, AxiscBool bArray)
{
	AxiscBool blnIsNewPrefix = xsdc_boolean_false;
	AxiscBool blnIsNewSubElemPrefix = xsdc_boolean_false;
	const AxiscChar* sPrefix;


	// ======================================================================
	// If null input, serialize as nil element.
	// ======================================================================

	if ( param == NULL )
	{
		axiscSoapSerializerSerializeAsAttribute(pSZ, "xsi:nil", 0, (void*)&(xsdc_boolean_true), XSDC_BOOLEAN);
		axiscSoapSerializerSerialize(pSZ, ">", NULL);
		return AXISC_SUCCESS;
	}

	// ======================================================================
	// Serialize top-most element, possibly defining new namespace.
	// ======================================================================

	if (!bArray)
	{
		sPrefix = axiscSoapSerializerGetNamespacePrefix(pSZ,Axis_URI_Person, &blnIsNewPrefix);
		if (blnIsNewPrefix)
			axiscSoapSerializerSerialize(pSZ," xmlns:", sPrefix, "=\"", Axis_URI_Person, "\"", NULL);
	}

	// ======================================================================
	// Serialize attributes.
	// ======================================================================

	if (0 != param->gender)
		axiscSoapSerializerSerializeAsAttribute(pSZ,"gender", 0, (void*)(param->gender), XSDC_STRING);
	axiscSoapSerializerSerializeAsAttribute(pSZ,"vip", 0, (void*)&(param->vip), XSDC_BOOLEAN);
	axiscSoapSerializerSerialize(pSZ, ">", 0);

	// ======================================================================
	// Serialize sub-elements.
	// ======================================================================

	axiscSoapSerializerSerializeCmplxArray(pSZ, (const Axisc_Array *)param->aliases, (void*)Axis_Serialize_Alias, (void*)Axis_Delete_Alias, "aliases", "http://service.attributes.sample.webservice.wsdl2rpg.tools400.de/xsd");
	if (param->city != NULL)
		axiscSoapSerializerSerializeAsElement(pSZ, "city", "http://service.attributes.sample.webservice.wsdl2rpg.tools400.de/xsd", (void*)(param->city), XSDC_STRING);
	if (param->firstname != NULL)
		axiscSoapSerializerSerializeAsElement(pSZ, "firstname", "http://service.attributes.sample.webservice.wsdl2rpg.tools400.de/xsd", (void*)(param->firstname), XSDC_STRING);
	if (param->lastname != NULL)
		axiscSoapSerializerSerializeAsElement(pSZ, "lastname", "http://service.attributes.sample.webservice.wsdl2rpg.tools400.de/xsd", (void*)(param->lastname), XSDC_STRING);
	axiscSoapSerializerSerializeCmplxArray(pSZ, (const Axisc_Array *)param->email, (void*)Axis_Serialize_Email, (void*)Axis_Delete_Email, "email", "http://service.attributes.sample.webservice.wsdl2rpg.tools400.de/xsd");

	// ======================================================================
	// Remove namespace, if new.
	// ======================================================================

	if (!bArray && blnIsNewPrefix)
		axiscSoapSerializerRemoveNamespacePrefix(pSZ, Axis_URI_Person);

	return AXISC_SUCCESS;
}

/**
 ******************************************************************************
 * Function to deserialize an object of type Person.
 ******************************************************************************
 */

int Axis_DeSerialize_Person(Person* param, AXISCHANDLE pDZ)
{
	const char* peekedElementName;

	// ======================================================================
	// Deserialize attributes.
	// ======================================================================

	param->gender = axiscSoapDeSerializerGetAttributeAsString(pDZ, "gender",0);

	{
		xsdc__boolean * vip = axiscSoapDeSerializerGetAttributeAsBoolean(pDZ, "vip",0);
		if (vip != NULL)
		{
			param->vip = *vip;
			axiscAxisDelete( (void *) vip, XSDC_BOOLEAN);
		}
	}


	// ======================================================================
	// Deserialize elements.
	// ======================================================================

	axiscSoapDeSerializerGetCmplxArray(pDZ, (Axisc_Array *)param->aliases, (void*)Axis_DeSerialize_Alias, (void*)Axis_Create_Alias, (void*)Axis_Delete_Alias, "aliases", Axis_URI_Alias);

	param->city = axiscSoapDeSerializerGetElementAsString(pDZ, "city",0);

	param->firstname = axiscSoapDeSerializerGetElementAsString(pDZ, "firstname",0);

	param->lastname = axiscSoapDeSerializerGetElementAsString(pDZ, "lastname",0);

	axiscSoapDeSerializerGetCmplxArray(pDZ, (Axisc_Array *)param->email, (void*)Axis_DeSerialize_Email, (void*)Axis_Create_Email, (void*)Axis_Delete_Email, "email", Axis_URI_Email);



	// ======================================================================
	// Ensure no extraneous elements.
	// ======================================================================

	peekedElementName = axiscSoapDeSerializerPeekNextElementName(pDZ);
	if (0x00 != *peekedElementName)
		axiscAxisGenerateUnknownElementException(peekedElementName);

	return axiscSoapDeSerializerGetStatus(pDZ);
}

/**
 ******************************************************************************
 * Function used to create objects of type Person.
 ******************************************************************************
 */

void* Axis_Create_Person(int nSize)
{
	if (nSize > 0)
	{
		int i;
		Person** pNew = (Person**) axiscAxisNewCArray(nSize);
		for (i=0; i < nSize; ++i)
			pNew[i] = (Person*)Axis_Create_Person(0);
		return (void *)pNew;
	}
	else
	{
		Person* pTemp = (Person *)malloc(sizeof(Person));
		memset(pTemp, 0, sizeof(Person));

		pTemp->aliases = Axis_Create_Alias_Array(0);
		pTemp->email = Axis_Create_Email_Array(0);

		return pTemp;
	}
}

/**
 ******************************************************************************
 * Function used to delete objects of type Person.
 ******************************************************************************
 */

void Axis_Delete_Person(Person* param, int nSize)
{
	/* If NULL, just return */
	if (param == NULL)
		return;

	/* Reclaim memory resources (recursion is used to reclaim arrays) */
	if (nSize > 0)
	{
		int i;
		Person **paramArray = (Person **)param;
		for (i = 0 ; i < nSize ; i++ )
			if (paramArray[i])
				Axis_Delete_Person(paramArray[i],0);
		axiscAxisDeleteCArray((void **)param);
	}
	else
	{
		if (param->gender != NULL)
			axiscAxisDelete(param->gender,XSDC_STRING);

		if (param->aliases)
			Axis_Delete_Alias_Array(param->aliases, 0);
		if (param->city != NULL)
			axiscAxisDelete(param->city,XSDC_STRING);

		if (param->firstname != NULL)
			axiscAxisDelete(param->firstname,XSDC_STRING);

		if (param->lastname != NULL)
			axiscAxisDelete(param->lastname,XSDC_STRING);

		if (param->email)
			Axis_Delete_Email_Array(param->email, 0);
		free(param);
	}
}
