/*
 * Copyright 2003-2006 The Apache Software Foundation.

 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *		http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * This file was auto-generated by the Axis C++ Web Service Generator (WSDL2Ws)
 * This file contains functions to manipulate type Query
 */

#include <stdlib.h>
#include <string.h>

#include "Query.h"

#include <axis/client/Stub.h>
#include <axis/client/Call.h>
#include <axis/AxisWrapperAPI.h>
#include <axis/IWrapperSoapSerializer.h>
#include <axis/IWrapperSoapDeSerializer.h>


/**
 ******************************************************************************
 * Function to serialize an object of type Query.
 ******************************************************************************
 */

int Axis_Serialize_Query(Query* param, AXISCHANDLE pSZ, AxiscBool bArray)
{
	AxiscBool blnIsNewPrefix = xsdc_boolean_false;
	AxiscBool blnIsNewSubElemPrefix = xsdc_boolean_false;
	const AxiscChar* sPrefix;


	// ======================================================================
	// If null input, serialize as nil element.
	// ======================================================================

	if ( param == NULL )
	{
		axiscSoapSerializerSerializeAsAttribute(pSZ, "xsi:nil", 0, (void*)&(xsdc_boolean_true), XSDC_BOOLEAN);
		axiscSoapSerializerSerialize(pSZ, ">", NULL);
		return AXISC_SUCCESS;
	}

	// ======================================================================
	// Serialize top-most element, possibly defining new namespace.
	// ======================================================================

	if (!bArray)
	{
		sPrefix = axiscSoapSerializerGetNamespacePrefix(pSZ,Axis_URI_Query, &blnIsNewPrefix);
		if (blnIsNewPrefix)
			axiscSoapSerializerSerialize(pSZ," xmlns:", sPrefix, "=\"", Axis_URI_Query, "\"", NULL);
	}

	// ======================================================================
	// Serialize attributes.
	// ======================================================================

	if (0 != param->type)
		axiscSoapSerializerSerializeAsAttribute(pSZ,"type", 0, (void*)(param->type), XSDC_STRING);
	if (0 != param->targetDB)
		axiscSoapSerializerSerializeAsAttribute(pSZ,"targetDB", 0, (void*)(param->targetDB), XSDC_STRING);
	if (0 != param->enabled)
		axiscSoapSerializerSerializeAsAttribute(pSZ,"enabled", 0, (void*)(param->enabled), XSDC_BOOLEAN);
	axiscSoapSerializerSerializeAsAttribute(pSZ,"severity", 0, (void*)&(param->severity), XSDC_INT);
	axiscSoapSerializerSerialize(pSZ, ">", 0);

	// ======================================================================
	// Serialize extension.
	// ======================================================================

	axiscSoapSerializerSerializeAsChardata(pSZ,(void*)(param->Query_value), XSDC_STRING);

	// ======================================================================
	// Remove namespace, if new.
	// ======================================================================

	if (!bArray && blnIsNewPrefix)
		axiscSoapSerializerRemoveNamespacePrefix(pSZ, Axis_URI_Query);

	return AXISC_SUCCESS;
}

/**
 ******************************************************************************
 * Function to deserialize an object of type Query.
 ******************************************************************************
 */

int Axis_DeSerialize_Query(Query* param, AXISCHANDLE pDZ)
{
	const char* peekedElementName;

	// ======================================================================
	// Deserialize attributes.
	// ======================================================================

	param->type = axiscSoapDeSerializerGetAttributeAsString(pDZ, "type",0);

	param->targetDB = axiscSoapDeSerializerGetAttributeAsString(pDZ, "targetDB",0);

	param->enabled = axiscSoapDeSerializerGetAttributeAsBoolean(pDZ, "enabled",0);

	{
		xsdc__int * severity = axiscSoapDeSerializerGetAttributeAsInt(pDZ, "severity",0);
		if (severity != NULL)
		{
			param->severity = *severity;
			axiscAxisDelete( (void *) severity, XSDC_INT);
		}
	}


	// ======================================================================
	// Deserialize extension.
	// ======================================================================

	{
		void* pCharDataAs;

		axiscSoapDeSerializerGetChardataAs(pDZ, &pCharDataAs, XSDC_STRING);
		param->Query_value = (xsdc__string) pCharDataAs;
	}


	// ======================================================================
	// Ensure no extraneous elements.
	// ======================================================================

	peekedElementName = axiscSoapDeSerializerPeekNextElementName(pDZ);
	if (0x00 != *peekedElementName)
		axiscAxisGenerateUnknownElementException(peekedElementName);

	return axiscSoapDeSerializerGetStatus(pDZ);
}

/**
 ******************************************************************************
 * Function used to create objects of type Query.
 ******************************************************************************
 */

void* Axis_Create_Query(int nSize)
{
	if (nSize > 0)
	{
		int i;
		Query** pNew = (Query**) axiscAxisNewCArray(nSize);
		for (i=0; i < nSize; ++i)
			pNew[i] = (Query*)Axis_Create_Query(0);
		return (void *)pNew;
	}
	else
	{
		Query* pTemp = (Query *)malloc(sizeof(Query));
		memset(pTemp, 0, sizeof(Query));

		return pTemp;
	}
}

/**
 ******************************************************************************
 * Function used to delete objects of type Query.
 ******************************************************************************
 */

void Axis_Delete_Query(Query* param, int nSize)
{
	/* If NULL, just return */
	if (param == NULL)
		return;

	/* Reclaim memory resources (recursion is used to reclaim arrays) */
	if (nSize > 0)
	{
		int i;
		Query **paramArray = (Query **)param;
		for (i = 0 ; i < nSize ; i++ )
			if (paramArray[i])
				Axis_Delete_Query(paramArray[i],0);
		axiscAxisDeleteCArray((void **)param);
	}
	else
	{
		if (param->type != NULL)
			axiscAxisDelete(param->type,XSDC_STRING);

		if (param->targetDB != NULL)
			axiscAxisDelete(param->targetDB,XSDC_STRING);

		if (param->enabled != NULL)
			axiscAxisDelete(param->enabled,XSDC_BOOLEAN);

		free(param);
	}
}
